#include <windows.h>
#include <stdio.h>


FILE *fp;


UINT8 buf[0x800000];
INT32 bufSize;



// Doom 1/2 - gs reset #1


// alternative
UINT8 patch1Scan[] =
{
	0xB9, 0x06, 0x00, 0x00, 0x00,
	0x57,
	0x89, 0xC8,
	0xC1, 0xE9, 0x02,
	0xF2, 0xA5,
	0x8A, 0xC8,
	0x80, 0xE1, 0x03,
	0xF2, 0xA4,
	0x5F,
	0xB8, 0x06, 0x00, 0x00, 0x00
};


INT16 patch1Raw[] =
{
	0x57,
	0x83,	0xEE, 0x0B,
	0xB9, 0x0B, 0x00, 0x00, 0x00,
	0x89, 0xC8, 0xF2, 0xA4,
	0x5F,
	0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
	0xB8, 0x0B, 0x00, 0x00, 0x00
};



// normal
UINT8 patch1aScan[] =
{
	0xB9, 0x06, 0x00, 0x00, 0x00,
	0x57,
	0x89, 0xC8,
	0xC1, 0xE9, 0x02,
	0xF2, 0xA5,
	0x8A, 0xC8,
	0x80, 0xE1, 0x03,
	0xF2, 0xA4,
	0x5F
};


INT16 patch1aRaw[] =
{
	0x57,
	0x83,	0xEE, 0x0B,
	0xB9, 0x0B, 0x00, 0x00, 0x00,
	0x89, 0xC8, 0xF2, 0xA4,
	0x5F,
	0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90
};




// Doom 1/2 - gs reset #1 - pt2
UINT8 patch2Scan[] =
{
	0x42,
	0xE8, -1, -1, -1, -1,
	0x83, 0xFA, 0x06,
	0x7C, 0xED,

	0x5F, 0x5E, 0x5A, 0x59, 0xC3
};


INT16 patch2Raw[] =
{
	0x42,
	0xE8, -1, -1, -1, -1,
	0x83, 0xFA, 0x0B,
	0x7C, 0xED,

	0x5F, 0x5E, 0x5A, 0x59, 0xC3
};



// GM off - GS reset #2

// alternative
UINT8 patch3Scan[] =
{
	0xB9, 0x06, 0x00, 0x00, 0x00,
	0x57,
	0x89, 0xC8,
	0xC1, 0xE9, 0x02,
	0xF2, 0xA5,
	0x8A, 0xC8,
	0x80, 0xE1, 0x03,
	0xF2, 0xA4,
	0x5F,
	0xB8, 0x06, 0x00, 0x00, 0x00
};


INT16 patch3Raw[] =
{
	0x57,
	0x83,	0xEE, 0x11,
	0xB9, 0x0B, 0x00, 0x00, 0x00,
	0x89, 0xC8, 0xF2, 0xA4,
	0x5F,
	0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
	0xB8, 0x0B, 0x00, 0x00, 0x00
};



// normal

UINT8 patch3aScan[] =
{
	0xB9, 0x06, 0x00, 0x00, 0x00,
	0x57,
	0x89, 0xC8,
	0xC1, 0xE9, 0x02,
	0xF2, 0xA5,
	0x8A, 0xC8,
	0x80, 0xE1, 0x03,
	0xF2, 0xA4,
	0x5F
};


INT16 patch3aRaw[] =
{
	0x57,
	0x83,	0xEE, 0x11,
	0xB9, 0x0B, 0x00, 0x00, 0x00,
	0x89, 0xC8, 0xF2, 0xA4,
	0x5F,
	0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90
};




// GM off - GS reset #2 - pt2
UINT8 patch4Scan[] =
{
	0x42,
	0xE8, -1, -1, -1, -1,
	0x83, 0xFA, 0x06,
	0x7C, 0xED,

	0xB8, 0xFF, 0x00, 0x00, 0x00
};


INT16 patch4Raw[] =
{
	0x42,
	0xE8, -1, -1, -1, -1,
	0x83, 0xFA, 0x0B,
	0x7C, 0xED,

	0xB8, 0xFF, 0x00, 0x00, 0x00
};



INT Patch( INT type, INT addr, INT scanSize, INT patchSize, BYTE patchScan[], INT16 patchRaw[] )
{
	for( INT lcv = 0; lcv < scanSize; lcv++ )
	{
		// wildcard
		if( patchScan[ lcv ] == (UINT8) -1 )
			continue;


		if( patchScan[ lcv ] != buf[ addr + lcv ] )
			break;
	}


	// not found
	if( lcv != scanSize )
		return 0;


	// #################################################
	// #################################################
	// #################################################

	INT diff;


	if( type == 1 )
	{
		// Apogee special call
		//diff = *( (INT32 *) (buf + addr + 10) ) - (INT32) 0xFFFFFF6A;
	}



	for( lcv = 0; lcv < patchSize; lcv++ )
	{
		// wildcard
		if( patchRaw[ lcv ] == (INT16) -1 )
			continue;


		// ptr diff
		if( patchRaw[ lcv ] == (INT16) 0xE8FF )
		{
			buf[ addr + lcv ] = 0xE8;

			buf[ addr + lcv + 1 ] = (UINT8) patchRaw[ lcv + 1 ];
			buf[ addr + lcv + 2 ] = (UINT8) patchRaw[ lcv + 2 ];
			buf[ addr + lcv + 3 ] = (UINT8) patchRaw[ lcv + 3 ];
			buf[ addr + lcv + 4 ] = (UINT8) patchRaw[ lcv + 4 ];


			*( (INT32 *)( buf + addr + lcv + 1 ) ) += diff;


			lcv += 4;
			continue;
		}


		// ptr shift
		if( patchRaw[ lcv ] == (INT16) 0xBEEE )
		{
			buf[ addr + lcv ] = 0xBE;


			// Doom - GS reset
			diff = -11;



			*( (INT32 *)( buf + addr + lcv + 1 ) ) += diff;


			lcv += 4;
			continue;
		}


		buf[ addr + lcv ] = (UINT8) patchRaw[ lcv ];
	}


	return 1;
}



INT CALLBACK WinMain( HINSTANCE, HINSTANCE, LPSTR, INT )
{
	BOOL found;


	found = FALSE;


	fp = fopen( "DOOM.EXE", "rb+" );
	if( fp ) found = TRUE;


	if( !fp )
	{
		fp = fopen( "DOOM2.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "HERETIC.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "HEXEN.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "STRIFE.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "CHEX.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "HACX.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "RAP.EXE", "rb+" );
		if( fp ) found = TRUE;
	}




	if( !fp )
	{
		MessageBox( NULL, "No game found", "iD Software", MB_OK );
		return 0;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// file size
	fseek( fp, 0, SEEK_END );
	bufSize = ftell(fp);


	fseek( fp, 0, SEEK_SET );
	fread( buf, 1, bufSize, fp );



	bool patch[4] = { 0,0,0,0 };


	// scan for pattern
	for( INT lcv = 0; lcv < bufSize; lcv++ )
	{
		if( patch[0] == 0 &&
				( Patch( 1, lcv, sizeof(patch1Scan), sizeof(patch1Raw) / sizeof(INT16), patch1Scan, patch1Raw ) ||
					Patch( 1, lcv, sizeof(patch1aScan), sizeof(patch1aRaw) / sizeof(INT16), patch1aScan, patch1aRaw )) )
		{
			patch[0] = 1;
			MessageBox( 0, "Patch - GS reset #1", "Game patch", MB_OK );
		}


		if( patch[1] == 0 && Patch( 1, lcv, sizeof(patch2Scan), sizeof(patch2Raw) / sizeof(INT16), patch2Scan, patch2Raw ) )
		{
			patch[1] = 1;
			MessageBox( 0, "Patch - GS reset #1a", "Game patch", MB_OK );
		}


		if( patch[2] == 0 &&
				( Patch( 1, lcv, sizeof(patch3Scan), sizeof(patch3Raw) / sizeof(INT16), patch3Scan, patch3Raw ) ||
					Patch( 1, lcv, sizeof(patch3aScan), sizeof(patch3aRaw) / sizeof(INT16), patch3aScan, patch3aRaw )) )
		{
			patch[2] = 1;
			MessageBox( 0, "Patch - GS reset #2", "Game patch", MB_OK );
		}


		if( patch[3] == 0 && Patch( 1, lcv, sizeof(patch4Scan), sizeof(patch4Raw) / sizeof(INT16), patch4Scan, patch4Raw ) )
		{
			patch[3] = 1;
			MessageBox( 0, "Patch - GS reset #2b", "Game patch", MB_OK );
		}
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// set to write mode
	fseek( fp, 0, SEEK_SET );


	fwrite( buf, 1, bufSize, fp );
	fclose( fp );


	return 0;
}
